const nodemailer = require("nodemailer");
const dotenv = require("dotenv");

// Load environment variables
dotenv.config({ path: "./config.env" });

// Generate a 6-digit OTP
function generateOTP() {
  return Math.floor(100000 + Math.random() * 900000).toString(); // Generate a 6-digit OTP
}

// Create a transporter to send emails
async function createTransporter() {
  return nodemailer.createTransport({
    service: "Gmail", // Use Gmail's SMTP service
    auth: {
      user: process.env.EMAIL_USER, // Your email address
      pass: process.env.EMAIL_PASS, // Your email password or App-specific password
    },
  });
}

// Send the OTP for password reset
async function sendOTPEmailForPasswordReset(email, otp) {
  const transporter = await createTransporter();

  const mailOptions = {
    from: process.env.EMAIL_USER, // Sender address
    to: email, // Recipient address (user's email)
    subject: "Password Reset OTP", // Subject of the email
    text: `Your OTP for resetting your password is ${otp}. It is valid for 10 minutes. Please use it to complete the reset process.`, // OTP message
  };

  await transporter.sendMail(mailOptions); // Send the OTP email
}

// Send the OTP for email verification
async function sendOTPEmailForVerification(email, otp) {
  const transporter = await createTransporter();

  const mailOptions = {
    from: process.env.EMAIL_USER, // Sender address
    to: email, // Recipient address (user's email)
    subject: "Email Verification OTP", // Subject of the email
    text: `Your OTP for email verification is ${otp}. It is valid for 10 minutes. Please use it to complete the verification process.`, // OTP message
  };

  await transporter.sendMail(mailOptions); // Send the OTP email
}
// Export functions to be used in other files
module.exports = {
  generateOTP,
  sendOTPEmailForPasswordReset,
  sendOTPEmailForVerification,
};
