const multer = require("multer");
const path = require("path");

// Configure multer for file uploads
const storage = multer.diskStorage({
  destination: (req, file, cb) => {
    cb(null, "uploads/photos/"); // Set the destination folder for uploaded photos
  },
  filename: (req, file, cb) => {
    const uniqueSuffix = Date.now() + "-" + Math.round(Math.random() * 1e9);
    cb(null, uniqueSuffix + "-" + file.originalname); // Set the file name with a unique suffix
  },
});

// File filter to only accept image files
const fileFilter = (req, file, cb) => {
  // Accept only images (jpeg, png, gif, etc.)
  if (file.mimetype.startsWith("image/")) {
    cb(null, true);
  } else {
    // Reject non-image files
    cb(new Error("Please upload only images."), false); // Use default multer error handling
  }
};

// Set up Multer with the storage configuration, file filter, and optional limits (e.g., file size)
const upload = multer({
  storage,
  fileFilter,
  limits: {
    fileSize: 20 * 1024 * 1024, // Limit file size to 5MB
  },
});

// Export the upload middleware (use .single() for single file uploads)
module.exports = upload;
