const axios = require("axios"); // Import axios to make HTTP requests
require("dotenv").config(); // Load environment variables

// Function to fetch user info using LinkedIn access token
async function getUserInfoWithAccessToken(accessToken) {
  try {
    const response = await axios.get(
      "https://api.linkedin.com/v2/me", // LinkedIn API to fetch user profile
      {
        headers: {
          Authorization: `Bearer ${accessToken}`, // Send access token in the request header
        },
      }
    );

    const userInfo = response.data;

    console.log("User Info:", userInfo);
    return userInfo; // Contains user's first name, last name, ID, etc.
  } catch (error) {
    console.error("Error fetching user info:", error);
    throw new Error("Failed to fetch LinkedIn user info");
  }
}

// Function to verify the LinkedIn access token
async function verifyAccessToken(accessToken) {
  try {
    // LinkedIn doesn't have a tokeninfo endpoint like Google, so we can use the 'me' endpoint to verify token validity
    const response = await axios.get(
      "https://api.linkedin.com/v2/me", // Attempt to fetch user data as a way of verifying token
      {
        headers: {
          Authorization: `Bearer ${accessToken}`,
        },
      }
    );

    // If the token is valid, LinkedIn will return the user info
    const userInfo = response.data;

    // You can optionally add additional checks to validate that the user belongs to your app
    if (!userInfo) {
      throw new Error("Invalid token or failed to retrieve user info");
    }

    const userDetails = {
      id: userInfo.id, // LinkedIn user ID
      first_name: userInfo.firstName.localized.en_US, // First name of the user
      last_name: userInfo.lastName.localized.en_US, // Last name of the user
      profile_url: `https://www.linkedin.com/in/${userInfo.id}`, // Profile URL of the user
      headline: userInfo.headline.localized.en_US, // User's headline (job title, etc.)
      email: userInfo.emailAddress, // Email address, if available
    };

    console.log("Verified User Info:", userDetails);
    return {
      message: "LinkedIn token verified successfully",
      user: userDetails, // Return verified user details
    };
  } catch (error) {
    console.error("Error verifying LinkedIn token:", error);
    throw new Error("LinkedIn token verification failed: " + error.message);
  }
}

module.exports = {
  verifyAccessToken, // Export the function to be used elsewhere
  getUserInfoWithAccessToken,
};
