const axios = require("axios"); // Import axios to make HTTP requests
require("dotenv").config(); // Load environment variables

async function getUserInfoWithAccessToken(accessToken) {
  try {
    const response = await axios.get(
      "https://www.googleapis.com/oauth2/v3/userinfo",
      {
        headers: {
          Authorization: `Bearer ${accessToken}`,
        },
      }
    );

    const userInfo = response.data;

    console.log("User Info:", userInfo);
    return userInfo; // Contains user's email, name, profile picture, etc.
  } catch (error) {
    console.error("Error fetching user info:", error);
    throw new Error("Failed to fetch user info");
  }
}

// Function to verify the access token and fetch user details
async function verifyAccessToken(accessToken) {
  try {
    // Send a request to Google's tokeninfo endpoint to verify the access token
    const response = await axios.get(
      `https://www.googleapis.com/oauth2/v3/tokeninfo?access_token=${accessToken}`
    );

    // If the response is successful, it will contain the user's information
    const userInfo = response.data;

    // Check if the token's audience matches your client ID
    if (userInfo.aud !== process.env.GOOGLE_CLIENT_ID) {
      throw new Error("Token is not meant for this app");
    }
    console.log(userInfo);

    // Successfully verified token and obtained user info
    const userDetails = {
      id: userInfo.sub, // Google user ID
      name: userInfo.name,
      given_name: userInfo.given_name,
      family_name: userInfo.family_name,
      email: userInfo.email,
      picture: userInfo.picture, // Profile picture URL
      email_verified: userInfo.email_verified,
      locale: userInfo.locale,
    };

    // Logging user details for testing
    // console.log("User Info:", userDetails);

    return {
      message: "Login successful",
      user: userDetails, // Include user details in the response
    };
  } catch (error) {
    throw new Error("Token verification failed: " + error.message);
  }
}

module.exports = {
  verifyAccessToken, // Export the function to be used elsewhere
  getUserInfoWithAccessToken,
};
