const axios = require("axios");

exports.getUserCoordinates = async () => {
  try {
    const apiKey = process.env.Google_API_Key; // Replace with your Google API key
    const response = await axios.post(
      `https://www.googleapis.com/geolocation/v1/geolocate?key=${apiKey}`,
      {} // Empty body is required
    );

    const { lat, lng } = response.data.location;
    return { latitude: lat, longitude: lng };
  } catch (error) {
    console.error("Error fetching coordinates:", error.message);
    return null;
  }
};
exports.getLocationName = async (latitude, longitude) => {
  try {
    const apiKey = process.env.Google_API_Key; // Replace with your Google API key
    const response = await axios.get(
      `https://maps.googleapis.com/maps/api/geocode/json?latlng=${latitude},${longitude}&key=${apiKey}`
    );

    if (response.data.status === "OK" && response.data.results.length > 0) {
      return response.data.results[0].formatted_address; // Get the first result
    } else {
      throw new Error("No address found");
    }
  } catch (error) {
    console.error("Error getting location name:", error.message);
    return null;
  }
};
