const nodemailer = require("nodemailer");

module.exports = class Email {
  constructor(user, options = {}) {
    this.to = user.email;
    this.firstName = user.firstName || "User";
    this.url = options.url || null;
    this.OTP = options.OTP || null;
    this.user = user; // Full user object if needed
    this.from = `eladde,Inc <${process.env.EMAIL_FROM || "no-reply@example.com"}>`;
  }

  newTransport() {
    return nodemailer.createTransport({
      host: "smtp.gmail.com",
      port: 587,
      secure: false,
      auth: {
        user: process.env.EMAIL_USER,
        pass: process.env.EMAIL_PASS,
      },
      tls: {
        rejectUnauthorized: false,
      },
    });
  }

 async send(subject, text, html = null) {
  const mailOptions = {
    from: this.from,
    to: this.to,
    subject,
    text, // always include plain text
  };

  // Add HTML if provided
  if (html) {
    mailOptions.html = html;
  }

  try {
    await this.newTransport().sendMail(mailOptions);
  } catch (err) {
    console.error("Error sending email:", err);
    throw new Error("There was an error sending the email.");
  }
}

async sendWelcome() {
  const subject = "You’re in. Let’s build something meaningful.";

  const text = `Hi ${this.firstName},

Welcome to eladde. We’re really glad you’re here.

eladde helps you connect with people in real time, only when you’re in the same space. Think cafés, airport lounges, coworking spots, bars, or networking events — places where great conversations could happen, if given the chance.

What makes eladde different:
🟢 You choose when you’re visible
✋ No random messages. Only people you approve can reach out
🤝 Real people, nearby, right now
🧭 No feeds, no noise, just presence

If that resonates with you, share eladde with friends and family, and help us connect the world, one real moment at a time.

Thanks for helping build something meaningful.

Warmly,
Edrick
Founder, eladde
`;

  const html = `
    <p>Hi ${this.firstName},</p>
    <p>Welcome to <strong>eladde</strong>. We’re really glad you’re here.</p>
    <p>
      eladde helps you connect with people in real time, only when you’re in the same space.
      Think cafés, airport lounges, coworking spots, bars, or networking events —
      places where great conversations could happen, if given the chance.
    </p>
    <p><strong>What makes eladde different:</strong></p>
    <ul>
      <li>🟢 You choose when you’re visible</li>
      <li>✋ No random messages. Only people you approve can reach out</li>
      <li>🤝 Real people, nearby, right now</li>
      <li>🧭 No feeds, no noise, just presence</li>
    </ul>
    <p>
      If that resonates with you, share eladde with friends and family,
      and help us connect the world, one real moment at a time.
    </p>
    <p>
      Thanks for helping build something meaningful.
    </p>
    <p>
      Warmly,<br/>
      <strong>Edrick</strong><br/>
      Founder,<br/>
      eladde
    </p>
  `;

  await this.send(subject, text, html);
}


  async sendPasswordReset() {
    const subject = "OTP for Verification (valid for only 10 minutes)";
    const text = `Hello ${this.firstName},\n\nYour OTP is: ${this.OTP}\nThis OTP is valid for 10 minutes.\nIf you didn’t request this, you can ignore this email.\n\n— Ellade App`;
    await this.send(subject, text);
  }
};
