const Notification = require("../models/notificationModel");
const { emitToUser } = require("../utils/socket");

const createAndEmitNotification = async (userId, message, type, link) => {
  try {
    // Allowed notification types
    const validTypes = ["connection", "like", "comment", "message", "other"];
    if (!validTypes.includes(type)) {
      throw new Error("Invalid notification type.");
    }

    // Create and save notification
    const newNotification = new Notification({
      user: userId,
      message,
      type,
      link,
    });

    await newNotification.save();

    // Emit to the target user only
    emitToUser(userId.toString(), "New Notification", {
      message: newNotification.message,
      createdAt: newNotification.createdAt,
      link: newNotification.link,
      type: newNotification.type,
      id: newNotification._id,
    });

    console.log(`📤 Notification sent to user ${userId}`);
    return newNotification;
  } catch (error) {
    console.error("❌ Error creating and emitting notification:", error.message);
    console.error(
      `Failed to send notification to user ${userId} with message: ${message}`
    );
    throw error;
  }
};

module.exports = { createAndEmitNotification };
