const express = require("express");
const multer = require("multer");
const path = require("path");
const fs = require("fs");
const voiceMessageController = require("../controllers/voiceMessageController");
const { protect } = require("../controllers/authController");

const router = express.Router();

// Set up storage for audio files
const storage = multer.diskStorage({
  destination: (req, file, cb) => {
    const uploadPath = path.join(__dirname, "..", "uploads", "audio");
    fs.mkdirSync(uploadPath, { recursive: true }); // Ensure folder exists
    cb(null, uploadPath);
  },
  filename: (req, file, cb) => {
    const uniqueSuffix = Date.now() + "-" + Math.round(Math.random() * 1e9);
    cb(null, `${uniqueSuffix}${path.extname(file.originalname)}`);
  },
});



// Set limits and define the upload middleware
const upload = multer({
  storage,

  limits: { fileSize: 10 * 1024 * 1024 }, // Max 10MB per file
});

// Apply auth middleware to all routes
router.use(protect);

// Route: Send one or more voice messages to a user
router.post(
  "/message/:receiverId",
  upload.array("audio", 5), // Use "audio" as the key for Postman or frontend
  voiceMessageController.sendVoiceMessage
);

module.exports = router;
