const express = require("express");
const authController = require("./../controllers/authController");
const userController = require("../controllers/userController");
const { getAllOnlineUsers } = require("../utils/socket");
const checkCredits = require("../middlewares/checkCredits");
const router = express.Router();

// **Protected Routes** (require authentication)
// API route to get online users
router.get("/online-users", (req, res) => {
  const onlineUsers = getAllOnlineUsers();
  res.json({ status: true, data: onlineUsers });
});

router.patch("/update-interests/:id", userController.updateInterests);
router.patch("/update-info/:id", userController.updateProfileInfo);
router.use(authController.protect); // Protect all routes below this middleware

router.patch("/update-userinterests", userController.updateUserInterests);
router.patch("/update-interests", userController.updateInterest);
//Update interest

//Get Current User LoggedIn
router.get("/current-user", userController.getCurrentUserProfile);

// Get All Users
router.get("/all-users", userController.getAllUsers);

//Search User
router.get("/search", userController.searchUser);
router.get("/search-messaged-user", userController.searchMessagedUsers);
router.get("/search-interests", userController.searchUserInterest);

// Get Suggested Users based on current user's interests
router.get("/get-suggested-users", userController.getSuggestedUsers);
router.get("/get-homesuggested-users", userController.getAllSuggestedUsers);
router.post("/decline-users", userController.declineUser);
// Route to check profile visibility status
router.get(
  "/check-profile-visibility",
  authController.protect,
  userController.checkProfileVisibility
);

// Get user by ID
router.get("/:id",checkCredits, userController.getUserById);

// Route to update the profile picture
router.patch("/profile-picture", userController.updateProfilePicture);

// Route to update bio and social links
router.patch("/update-profile/bio-links", userController.updateProfileBioLink);

// Route to update the current user's profile
router.put(
  "/update-profile/edit-info",
  userController.updateCurrentUserProfile
);

// Route to get the current user's profile completion percentage
router.get("/profile/completion", userController.getProfileCompletion);

//Route to toggle visible or not visible user profile
router.patch("/toggle-visibility", userController.toggleVisibility);

// Route to set profile visibility
router.patch("/set-profile-visibility", userController.setProfileVisibility);

// Route to unhide profile manually
router.patch("/unhide-profile", userController.unhideProfile);

//Route to get User location
router.post("/user-location", userController.getUserLocation);

//Route to get User credit
router.post("/user-credits", userController.getUserCredit);

router.delete("/remove-interest", userController.removeInterest);

module.exports = router;
