const express = require("express");
const { saveFCMToken } = require("../controllers/userController");
const {
  sendPushNotification,
} = require("../controllers/pushNotificationController");
const { protect } = require("../controllers/authController");

const router = express.Router();

router.post("/save-fcm-token", protect, saveFCMToken); // Save FCM Token
router.post("/send-notification", protect, sendPushNotification); // Send Push Notification

module.exports = router;
