// routes/profileVisibilityRoutes.js
const express = require('express');
const router = express.Router();
const profileVisibilityController = require('../controllers/profileVisibilityController');
const { protect } = require("../controllers/authController");

// Get profile visibility settings of the logged-in user
router.get('/', protect, profileVisibilityController.getProfileVisibilitySettings);

// Update profile visibility settings of the logged-in user
router.put('/update', protect, profileVisibilityController.updateProfileVisibilitySettings);

module.exports = router;