// routes/creditRoutes.js
const express = require("express");
const router = express.Router();
const creditController = require("../controllers/paymentController");
const authController = require("../controllers/authController");

// Protected routes (require authentication)
router.use(authController.protect);

// Create Stripe Checkout Session
router.post("/create-checkout-session", creditController.createCheckoutSession);




// Webhook endpoint (needs raw body)
router.post(
  "/webhook",
  express.raw({ type: "application/json" }), // Important for Stripe signature verification
  creditController.webhookCheckout
);
router.get("/user-detail", creditController.getUserPayments);
router.get("/payment-details/:paymentId", creditController.getPaymentDetails);

// Verify Apple In-App Purchase receipt
router.post("/verify-iap", creditController.verifyIAPReceipt);

module.exports = router;
