const express = require("express");
const router = express.Router();
const notificationController = require("../controllers/notificationController");
const { protect } = require("../controllers/authController");

// 🔒 Protect all notification routes
router.use(protect);

// ✅ Specific routes FIRST (to avoid conflicts with :notificationId)

// Get notifications
router.get("/", notificationController.getNotifications);

// Mark ALL as read
router.post("/mark-all-read", notificationController.markAllAsRead);

// Delete ALL (soft delete)
router.delete("/delete-all", notificationController.softDeleteAllNotifications);

// Mark a single notification as read
router.post("/:notificationId/read", notificationController.markAsRead);

// Soft delete a single notification
router.delete("/:notificationId", notificationController.softDeleteNotification);

module.exports = router;
