const express = require("express");
const router = express.Router();
const {
  getUsersForSidebar,
  getMessages,
  sendMessage,
  getLastMessages,
  seenMessage,
  updateMessage,
  deleteMessage,
  typingStatus,
  getMessagedUsers,
} = require("../controllers/messageController");
const { protect } = require("../controllers/authController"); // Middleware for authentication

// ✅ Fetch users for the sidebar (excluding logged-in user)
router.get("/users", protect, getUsersForSidebar);

// ✅ Fetch conversations list (users the logged-in user has messaged)
router.get("/conversations", protect, getMessagedUsers);

// ✅ Fetch last message with a specific user
router.get("/last/:id", protect, getLastMessages);

// ✅ Mark a message as seen
router.post("/seen", protect, seenMessage);

// ✅ Update a message
router.post("/update", protect, updateMessage);

// ✅ Delete a message
router.post("/delete", protect, deleteMessage);

// ✅ Send a message to a specific user
router.post("/send/:id", protect, sendMessage);

// ✅ Handle typing status
router.post("/typing", protect, typingStatus);

// ✅ Fetch all chat messages with a specific user (⚠️ placed LAST to avoid conflicts)
router.get("/:id", protect, getMessages);

module.exports = router;
