// routes/lockRoutes.js
const express = require("express");
const router = express.Router();
const lockController = require("../controllers/lockController"); // Controller handling lock-related logic
const { protect } = require("../controllers/authController");

// Set lock time for user
router.post("/set-lock", protect, lockController.setLockTime);

// Sample route to simulate user activity and update last access time
router.post("/user-action", protect, lockController.updateLastAccessTime);

// Check lock status of the user
router.get("/check-lock", protect, lockController.checkLockStatus);

// Manually unlock the app
router.post("/unlock-app", protect, lockController.unlockApp);

module.exports = router;
