const express = require("express");
const router = express.Router();
const {
  createInterestTab,
  getAllInterestTabs,
  getInterestTabByCategory,
  updateInterestTab,
  deleteInterestTab,
  SearchInterest,
  getTop3PopularInterests,
} = require("../controllers/interestController");
const authController = require("../controllers/authController");

// Create a new Interest Tab
router.post("/interest-tabs", authController.protect, createInterestTab);

// Get all Interest Tabs
router.get("/interest-tabs", authController.protect, getAllInterestTabs);

// Get a specific Interest Tab by category
router.get(
  "/interest-tabs/:topCategory",
  authController.protect,
  getInterestTabByCategory
);

// Update an Interest Tab's interests by category
router.put(
  "/interest-tabs/:topCategory",
  authController.protect,
  updateInterestTab
);

// Delete an Interest Tab by category
router.delete(
  "/interest-tabs/:topCategory",
  authController.protect,
  deleteInterestTab
);

router.get("/search-interests", authController.protect, SearchInterest);
router.get("/top-three", authController.protect, getTop3PopularInterests);

module.exports = router;
