// routes/socketRoutes.js
const express = require("express");
const multer = require("multer");
const path = require("path");
const { protect } = require("../controllers/authController");
const { sendImages } = require("../controllers/imgSocketController");

// Set up multer for image uploads
const storage = multer.diskStorage({
  destination: (req, file, cb) => {
    const uploadPath = path.join(__dirname, "..", "uploads", "photos");
    cb(null, uploadPath);
  },
  filename: (req, file, cb) => {
    const uniqueSuffix = Date.now() + "-" + Math.round(Math.random() * 1e9);
    cb(null, uniqueSuffix + "-" + file.originalname); // Ensure unique filenames
  },
});

const upload = multer({
  storage,
  limits: { fileSize: 10 * 1024 * 1024 }, // Limit size to 10MB per file
}).array("images[]", 6); // Accept up to 5 files with the name 'images[]'

const router = express.Router();

// POST route for sending images
router.post("/send-image", protect, upload, sendImages);

module.exports = router;
