const express = require("express");
const router = express.Router();
const connectionController = require("../controllers/connectionController");
const { protect } = require("../controllers/authController");
const checkCredits = require("../middlewares/checkCredits");
// Route to send a connection request
router.post(
  "/send-connection-request",
  protect,checkCredits,
  connectionController.sendConnectionRequest
);

// Route to accept a connection request
router.post(
  "/accept-connection-request",
  protect,checkCredits,
  connectionController.acceptConnectionRequest
);

// Route to reject a connection request
router.post(
  "/reject-connection-request",
  protect,checkCredits,
  connectionController.rejectConnectionRequest
);

// Route to get all connections (pending or accepted)
router.get(
  "/user-connections",
  protect,
  connectionController.getUserConnections
);
// router.get("/mutuals");

//Routes to get all the requests
router.get("/requests", protect, connectionController.getConnectionRequests);
// Add additional routes for other advanced features as necessary

router.delete(
  "/cancel-request/:receiverId",
  protect,checkCredits,
  connectionController.cancelConnectionRequest
);

module.exports = router;
