const express = require("express");
// const passport = require("passport");
// const { Strategy: GoogleStrategy } = require("passport-google-oauth20");
const AppError = require("../utils/appError");
const User = require("../models/userModel");
const authController = require("../controllers/authController");
const router = express.Router();

// **Public Routes** (no authentication required)
router.post("/signup-name", authController.signupName); // Step 1: Name (First and Last Name)
router.post("/signup-email/:tempUserId", authController.signupEmail); // Step 2: Email
router.post("/signup-password/:tempUserId", authController.signupPassword); // Step 3: Password
router.post(
  "/signup-profileInfo/:tempUserId",
  authController.signupProfileInfo
); // Step 4: Profile Info
router.post("/signup-interests/:tempUserId", authController.signupInterests); // Step 5: Interests
router.post("/signup-addPhoto/:tempUserId", authController.signupPhoto); // Step 6: Add Photo (optional)
router.post("/resend-otp/:tempUserId", authController.resendOTP);
router.post("/signup-verifyOTP/:tempUserId", authController.verifyOTP); // Step 7: Verify OTP

// router.post("/signup", authController.signup);
router.post("/login", authController.login);
router.get("/logout",
  authController.protect, authController.logout);
router.get("/check", authController.protect, authController.checkAuth);

// Route to update the current user's password
router.delete(
  "/deleteAccount",
  authController.protect,
  authController.deleteAccount
);
router.patch(
  "/updateMyPassword",
  authController.protect,
  authController.updatePassword
);

// update profile by id
router.patch("/profile-picture/:id", authController.updateProfilePicture);

module.exports = router;
