// routes/appLockRoutes.js
const express = require("express");
const router = express.Router();
const appLockController = require("../controllers/appLockController");
const { protect } = require("../controllers/authController");

// Get app lock settings of the logged-in user
router.get("/", protect, appLockController.getAppLockSettings);

// Update app lock settings of the logged-in user
router.put("/update", protect, appLockController.updateAppLockSettings);

module.exports = router;