const express = require("express");
const { adminAuth } = require("../../middlewares/adminAuth");
const {
  messageController,
} = require("../../controllers/admin/messageController");

const router = express.Router();

router.get("/", adminAuth, messageController.getAllConversations);

router.get(
  "/user/:id/conversations",
  adminAuth,
  messageController.getUserConversations
);

module.exports = router;
