// const mongoose = require("mongoose");

// const paymentSchema = new mongoose.Schema({
//   paymentId: { type: String, required: true },
//   amount: Number,
//   currency: { type: String, default: 'USD' },
//   status: { type: String, enum: ['pending', 'completed', 'failed', 'refunded'], default: 'pending' },
//   created: { type: Date, default: Date.now },
//   customerId: String,
//   user_id: { type: mongoose.Schema.Types.ObjectId, ref: "User" },
//   paymentMethod: { type: String, enum: ['stripe', 'tap', 'apple_iap'], required: true },
//   // IAP specific fields
//   iapData: {
//     transactionId: String,
//     productId: String,
//     originalTransactionId: String,
//     purchaseDate: Date,
//     expirationDate: Date,
//     isTrialPeriod: Boolean,
//     isInIntroOfferPeriod: Boolean,
//     environment: String,
//     rawResponse: Object
//   }
// });

// module.exports = mongoose.model("Payment", paymentSchema);


const mongoose = require("mongoose");

const paymentSchema = new mongoose.Schema({
  paymentId: { type: String, required: true },
  amount: Number,
  currency: { type: String, default: "USD" },
  status: {
    type: String,
    enum: ["pending", "completed", "failed", "refunded"],
    default: "pending",
  },
  created: { type: Date, default: Date.now },
  credits: { type: Number, default: 5 },
  customerId: String,
  user_id: { type: mongoose.Schema.Types.ObjectId, ref: "User" },
  paymentMethod: {
    type: String,
    enum: ["stripe", "tap", "apple_iap"],
    required: true,
  },
  // IAP specific fields
  iapData: {
    transactionId: String,
    productId: String,
    originalTransactionId: String,
    purchaseDate: Date,
    expirationDate: Date,
    isTrialPeriod: Boolean,
    isInIntroOfferPeriod: Boolean,
    environment: String,
    rawResponse: Object,
  },
});

module.exports = mongoose.model("Payment", paymentSchema);
