// models/notificationLogModel.js
const mongoose = require("mongoose");

const notificationLogSchema = new mongoose.Schema({
  fromUser: { type: mongoose.Schema.Types.ObjectId, ref: "User", required: true },
  toUser: { type: mongoose.Schema.Types.ObjectId, ref: "User", required: true },
  placeId: { type: String, required: true },
  createdAt: { type: Date, default: Date.now, expires: 3600 }, // auto-expire in 1 hour
});

const NotificationLog = mongoose.model("NotificationLog", notificationLogSchema);
module.exports = NotificationLog;
