const mongoose = require("mongoose");

// Define the schema for the Interest Tab
const interestTabSchema = new mongoose.Schema(
  {
    topCategory: {
      type: String,
      required: true,
      enum: ["popular", "suggestions", "around you", "work"], // You can add more categories like this
      trim: true,
    },
    interests: [
      {
        title: {
          type: String,
          required: true,
          trim: true,
        },
      },
    ],
  },
  {
    timestamps: true,
  }
);

// Create the InterestTab model
const InterestTab = mongoose.model("InterestTab", interestTabSchema);

module.exports = InterestTab;
