const mongoose = require("mongoose");

const DeclinedUserSchema = new mongoose.Schema(
  {
    sender: {
      type: mongoose.Schema.Types.ObjectId,
      ref: "User",
      required: true,
    },
    receiver: {
      type: mongoose.Schema.Types.ObjectId,
      ref: "User",
      required: true,
    },
    reason: {
      type: String,
      default: "No reason provided",
    },
    declinedAt: {
      type: Date,
      default: Date.now,
    },
  },
  { timestamps: true }
);

const DeclinedUser = mongoose.model("DeclinedUser", DeclinedUserSchema);

module.exports = DeclinedUser;
