const User = require("../models/userModel");

const checkCredits = async (req, res, next) => {
  try {
    const userId = req.user._id; // Get user ID from auth middleware

    // Fetch user data
    const user = await User.findById(userId);
    if (!user) {
      return res.status(404).json({ status: false, error: "User not found." });
    }

    // Check if user has enough credits
    if (user.credits <= 0) {
      return res.status(403).json({
        status: false,
        error: "You have run out of credits. Please recharge to continue.",
      });
    }

    next(); // Allow request to proceed
  } catch (error) {
    console.error("Error checking credits:", error.message);
    res.status(500).json({
      status: false,
      error: "Something went wrong while checking credits.",
    });
  }
};

module.exports = checkCredits;
