import userModel from "../models/userModel.js";
import jwt from "jsonwebtoken";

// Middleware to check if the user is an admin

export const adminAuth = async (req, res, next) => {
    try {
        const token = req.headers.authorization?.split(" ")[1];
        if (!token) {
            return res
                .status(401)
                .json({ status: false, message: "Unauthorized" });
        }

        const decoded = jwt.verify(token, process.env.JWT_SECRET);

        const user = await userModel
            .findById(decoded.id)
            .select("-password -__v");

        if (!user || !user.role || user.role !== "admin") {
            return res
                .status(403)
                .json({ status: false, message: "Forbidden" });
        }

        req.user = user;
        next();
    } catch (error) {
        console.error("Admin Auth Error:", error);
        res.status(500).json({ message: "Internal Server Error" });
    }
};
