// controllers/profileVisibilityController.js
const User = require("../models/userModel");

const getProfileVisibilitySettings = async (req, res) => {
  try {
    // The authenticated user's ID is available in req.user (set by the protect middleware)
    const user = await User.findById(req.user.id);

    if (!user) {
      return res.status(404).json({ message: 'User not found' });
    }

    res.status(200).json({ profileVisibility: user.profileVisibility });
  } catch (error) {
    res.status(500).json({ message: 'Error fetching profile visibility settings', error: error.message });
  }
};

// Update profile visibility settings of the logged-in user
const updateProfileVisibilitySettings = async (req, res) => {
  const updates = req.body;

  try {
    // The authenticated user's ID is available in req.user (set by the protect middleware)
    const user = await User.findByIdAndUpdate(
      req.user.id,
      { $set: { profileVisibility: updates } },
      { new: true, runValidators: true }
    );

    if (!user) {
      return res.status(404).json({ message: 'User not found' });
    }

    res.status(200).json({ message: 'Profile visibility settings updated successfully', user });
  } catch (error) {
    res.status(500).json({ message: 'Error updating profile visibility settings', error: error.message });
  }
};

module.exports = {
  getProfileVisibilitySettings,
  updateProfileVisibilitySettings,
};