// controllers/privacyController.js
const User = require("../models/userModel");

// Update user privacy preferences
const updatePrivacyPreferences = async (req, res) => {
  const updates = req.body;

  try {
    // The authenticated user's ID is available in req.user (set by the protect middleware)
    const user = await User.findByIdAndUpdate(
      req.user.id,
      { $set: { privacyPreferences: updates } },
      { new: true, runValidators: true }
    );

    if (!user) {
      return res.status(404).json({ message: 'User not found' });
    }

    res.status(200).json({ message: 'Privacy preferences updated successfully', user });
  } catch (error) {
    res.status(500).json({ message: 'Error updating privacy preferences', error: error.message });
  }
};

// Get user privacy preferences
const getPrivacyPreferences = async (req, res) => {
  try {
    // The authenticated user's ID is available in req.user (set by the protect middleware)
    const user = await User.findById(req.user.id);

    if (!user) {
      return res.status(404).json({ message: 'User not found' });
    }

    res.status(200).json({ privacyPreferences: user.privacyPreferences });
  } catch (error) {
    res.status(500).json({ message: 'Error fetching privacy preferences', error: error.message });
  }
};
module.exports = {
  updatePrivacyPreferences,
  getPrivacyPreferences,
};