// controllers/notificationsController.js
const User = require("../models/userModel");

// Get notification settings of the logged-in user
const getNotificationSettings = async (req, res) => {
  try {
    // The authenticated user's ID is available in req.user (set by the protect middleware)
    const user = await User.findById(req.user.id);

    if (!user) {
      return res.status(404).json({ message: 'User not found' });
    }

    res.status(200).json({ notifications: user.notifications });
  } catch (error) {
    res.status(500).json({ message: 'Error fetching notification settings', error: error.message });
  }
};

// Update notification settings of the logged-in user
const updateNotificationSettings = async (req, res) => {
  const updates = req.body;

  try {
    // The authenticated user's ID is available in req.user (set by the protect middleware)
    const user = await User.findByIdAndUpdate(
      req.user.id,
      { $set: { notifications: updates } },
      { new: true, runValidators: true }
    );

    if (!user) {
      return res.status(404).json({ message: 'User not found' });
    }

    res.status(200).json({ message: 'Notification settings updated successfully', user });
  } catch (error) {
    res.status(500).json({ message: 'Error updating notification settings', error: error.message });
  }
};

module.exports = {
  getNotificationSettings,
  updateNotificationSettings,
};