const linkedinAuth = require("../utils/linkedinAuth"); // Import LinkedIn authentication helper
const User = require("../models/userModel"); // Import User model

// Handle LinkedIn authentication
async function authenticateLinkedIn(req, res) {
  // const { access_token } = req.body; // Get access token from request
  const access_token =
    "AQXN6n5oYerlDfe4goU7eW8fq8zSK1AltFWIhl2fFRbtrbYGhQ66Vq_6wMVxsJKI7cTAB-Ha099TCJBdqT7fN4N8by8xXj-JwUAXIEwfioSmdFZj4CoWBP8npUplT7hfKSgr85yFtandzn2cpjIKYM6hkknkSKKVBgW02e9bwKmfdhESkSPYt2DcRpIZKEEPBXA6f0SIyOpPmRgQL9ZQW_Gz5qw6SYCMj1Be7PAy1kmTCcW5-72prrnxZWGO1sAW-mcdE6k1stVWHQ4bkwXChb3I-saRGZ4T_HEcuhGrtN3fR_487QI52OoGeKlltZxQKkRm2W_7PppRU--OFVGcws2xSlOF9w";
  console.log(access_token);

  if (!access_token) {
    return res.status(400).send("Access token is missing");
  }

   try {
    // Step 1: Verify access token and retrieve LinkedIn user details
    const user = await linkedinAuth.verifyAccessToken(access_token);

    // Step 2: Get the user's email address from LinkedIn
    const email = await linkedinAuth.getUserEmail(access_token);

    // Step 3: Check if the user already exists in the database
    let existingUser = await User.findOne({ email });

    if (existingUser) {
      // Update user information
      existingUser.firstName = user.first_name;
      existingUser.lastName = user.last_name;
      existingUser.headline = user.headline;
      existingUser.active = true;
      existingUser.photo = null; // Ensure photo is set to null

      await existingUser.save(); // Save updated user information to the database

      return res.json({
        status: true,
        message: "User info updated successfully",
        user: existingUser,
      });
    } else {
      // Create a new user if not found
      const newUser = new User({
        firstName: user.first_name,
        lastName: user.last_name,
        email,
        headline: user.headline,
        role: "user", // Default role
        active: true,
        photo: null, // Set photo to null
      });

      await newUser.save(); // Save the new user to the database

      return res.json({
        status: true,
        message: "User created successfully",
        user: newUser,
      });
    }
  } catch (error) {
    console.error("❌ Error authenticating with LinkedIn:", error.message);
    return res.status(400).json({
      status: false,
      error: "Error authenticating with LinkedIn: " + error.message,
    });
  }
}

module.exports = {
  authenticateLinkedIn,
};
