// controllers/appLockController.js
const User = require("./../models/userModel");

// Get app lock settings for the logged-in user
const getAppLockSettings = async (req, res) => {
  try {
    // The authenticated user's ID is available in req.user (set by the protect middleware)
    const user = await User.findById(req.user.id);

    if (!user) {
      return res.status(404).json({ message: "User not found" });
    }

    res.status(200).json({ appLock: user.appLock });
  } catch (error) {
    res.status(500).json({ message: "Error fetching app lock settings", error: error.message });
  }
};

// Update app lock settings for the logged-in user
const updateAppLockSettings = async (req, res) => {
  const { enabled, lockTiming, biometricsEnabled } = req.body;

  try {
    // The authenticated user's ID is available in req.user (set by the protect middleware)
    const user = await User.findByIdAndUpdate(
      req.user.id,
      { $set: { appLock: { enabled, lockTiming, biometricsEnabled } } },
      { new: true, runValidators: true }
    );

    if (!user) {
      return res.status(404).json({ message: "User not found" });
    }

    res.status(200).json({ message: "App lock settings updated successfully", user });
  } catch (error) {
    res.status(500).json({ message: "Error updating app lock settings", error: error.message });
  }
};

module.exports = {
  getAppLockSettings,
  updateAppLockSettings,
};