import userModel from "../../models/userModel.js";

// USER Related Controller
export let userController = {
    async getAllUsers(req, res) {
        try {
            const page = parseInt(req.query.page) || 1;
            const limit = parseInt(req.query.limit) || 10;
            const search = req.query.search || "";
            const status = req.query.status;
            const country = req.query.country || "";
            const skip = (page - 1) * limit;
            const query = {};

            if (search) {
                query.$or = [
                    { firstName: { $regex: search, $options: "i" } },
                    { lastName: { $regex: search, $options: "i" } },
                    { email: { $regex: search, $options: "i" } },
                ];
            }

            if (status === "active") {
                query.active = true;
            } else if (status === "deleted") {
                query.active = false;
            }

            if (country && country !== "all") {
                query.address = { $regex: country, $options: "i" };
            }

            const users = await userModel.find(query).skip(skip).limit(limit);
            // .select(
            //     "firstName lastName email interests address active createdAt lastAccessTime"
            // );
            const totalUsers = await userModel.countDocuments(query);

            res.status(200).json({
                status: "success",
                data: {
                    users,
                    totalUsers,
                    currentPage: page,
                    totalPages: Math.ceil(totalUsers / limit),
                },
            });
        } catch (err) {
            res.status(500).json({
                status: "error",
                message: err.message,
            });
        }
    },
};
