import Notification from "../../models/notificationModel.js";

export const notificationController = {
  async getAllNotifications(req, res) {
    try {
      const page = parseInt(req.query.page) || 1;
      const limit = parseInt(req.query.limit) || 10;
      const search = req.query.search || "";

      const filter = {};

      if (search) {
        filter.message = { $regex: search, $options: "i" };
      }

      const notifications = await Notification.find(filter)
        .populate("user", "firstName lastName email")
        .populate("senderId", "firstName lastName email")
        .sort({ createdAt: -1 })
        .skip((page - 1) * limit)
        .limit(limit);

      const total = await Notification.countDocuments(filter);

      res.json({
        data: notifications,
        total,
        page,
        limit,
      });
    } catch (err) {
      console.error("Get Notifications error:", err);
      res.status(500).json({ error: "Server error" });
    }
  },
};
