import Payment from "../../models/paymentModel.js";
import User from "../../models/userModel.js";

export const creditController = {
  async getAllCreditPurchases(req, res) {
    try {
      const { page = 1, limit = 10, search, status, method } = req.query;

      const query = {};
      if (status) query.status = status;
      if (method) query.paymentMethod = method;
      if (search) {
        query.$or = [
          { paymentId: { $regex: search, $options: "i" } },
          { customerId: { $regex: search, $options: "i" } },
        ];
      }

      const skip = (Number(page) - 1) * Number(limit);

      const data = await Payment.find(query)
        .populate("user_id", "firstName lastName email")
        .sort({ created: -1 })
        .skip(skip)
        .limit(Number(limit));

      const total = await Payment.countDocuments(query);

      // Calculate metrics on ALL data (not paginated)
      const completedPayments = await Payment.find({ status: "completed" });
      const totalRevenue = completedPayments.reduce(
        (sum, p) => sum + (p.amount || 0),
        0
      );
      const totalPurchases = await Payment.countDocuments();
      const averageAmount =
        totalPurchases > 0 ? totalRevenue / totalPurchases : 0;

      res.json({
        data,
        total,
        metrics: {
          totalRevenue,
          totalPurchases,
          averageAmount,
        },
      });
    } catch (e) {
      console.error(e);
      res.status(500).json({ message: "Server error" });
    }
  },
};
