import User from "../../models/userModel.js";
import Connection from "../../models/connectionModel.js";
import Message from "../../models/messageModel.js";
import Payment from "../../models/paymentModel.js";

export let adminController = {
  async getDashboard(req, res) {
    try {
      const now = new Date();
      const firstDayOfThisMonth = new Date(
        now.getFullYear(),
        now.getMonth(),
        1
      );
      const firstDayOfLastMonth = new Date(
        now.getFullYear(),
        now.getMonth() - 1,
        1
      );
      const lastDayOfLastMonth = new Date(now.getFullYear(), now.getMonth(), 0);

      const totalUsers = await User.countDocuments();
      const lastMonthUsers = await User.countDocuments({
        created: { $gte: firstDayOfLastMonth, $lte: lastDayOfLastMonth },
      });
      const thisMonthUsers = await User.countDocuments({
        created: { $gte: firstDayOfThisMonth },
      });
      const usersChange =
        lastMonthUsers === 0
          ? 0
          : ((thisMonthUsers - lastMonthUsers) / lastMonthUsers) * 100;

      const totalConnections = await Connection.countDocuments();
      const lastMonthConnections = await Connection.countDocuments({
        created: { $gte: firstDayOfLastMonth, $lte: lastDayOfLastMonth },
      });
      const thisMonthConnections = await Connection.countDocuments({
        created: { $gte: firstDayOfThisMonth },
      });
      const connectionsChange =
        lastMonthConnections === 0
          ? 0
          : ((thisMonthConnections - lastMonthConnections) /
              lastMonthConnections) *
            100;

      const totalMessages = await Message.countDocuments();
      const lastMonthMessages = await Message.countDocuments({
        created: { $gte: firstDayOfLastMonth, $lte: lastDayOfLastMonth },
      });
      const thisMonthMessages = await Message.countDocuments({
        created: { $gte: firstDayOfThisMonth },
      });
      const messagesChange =
        lastMonthMessages === 0
          ? 0
          : ((thisMonthMessages - lastMonthMessages) / lastMonthMessages) * 100;

      const totalRevenueResult = await Payment.aggregate([
        { $match: { status: "completed" } },
        { $group: { _id: null, total: { $sum: "$amount" } } },
      ]);
      const totalRevenue = totalRevenueResult[0]?.total || 0;

      const lastMonthRevenueResult = await Payment.aggregate([
        {
          $match: {
            status: "completed",
            created: { $gte: firstDayOfLastMonth, $lte: lastDayOfLastMonth },
          },
        },
        { $group: { _id: null, total: { $sum: "$amount" } } },
      ]);
      const lastMonthRevenue = lastMonthRevenueResult[0]?.total || 0;

      const thisMonthRevenueResult = await Payment.aggregate([
        {
          $match: {
            status: "completed",
            created: { $gte: firstDayOfThisMonth },
          },
        },
        { $group: { _id: null, total: { $sum: "$amount" } } },
      ]);
      const thisMonthRevenue = thisMonthRevenueResult[0]?.total || 0;

      const revenueChange =
        lastMonthRevenue === 0
          ? 0
          : ((thisMonthRevenue - lastMonthRevenue) / lastMonthRevenue) * 100;

      res.json({
        metrics: {
          totalUsers,
          usersChange: Number(usersChange.toFixed(1)),

          totalConnections,
          connectionsChange: Number(connectionsChange.toFixed(1)),

          totalMessages,
          messagesChange: Number(messagesChange.toFixed(1)),

          totalRevenue: Number(totalRevenue.toFixed(2)),
          revenueChange: Number(revenueChange.toFixed(1)),
        },
      });
    } catch (error) {
      console.error("Dashboard error:", error);
      res.status(500).json({ error: "Server error" });
    }
  },
};
